<?php
/* フォームより送信された値を取得します。 */
		$f_no = $_POST["f_no"];
		$f_name  = $_POST["f_name"];
		$f_kana = $_POST["f_kana"];
		$f_tel = $_POST["f_tel"];
/* どれか一つでも記入漏れや内容に誤りがあれば$errorに1をセットします。*/
		$error = 0;
		if ((!$f_no) || (!$f_name) || (!$f_kana) || (!$f_tel)) {$error = 1;}
/* mb_eregを使う際には、mb_regex_encoding()関数で正規表現内で使う文字エンコーディングを指定します。
   PHP 5.3 では必要です。PHP 5.4 では不要です。*/
		mb_regex_encoding("utf-8"); // UTF-8
/* no,kana,telのチェックをします。正しくなければ$errorに1をセットします */
		if (!ereg("[0-9]{4}", $f_no)) {$error = 1;}
		if (!mb_ereg("[ア-ン]+$",$f_kana)) {$error = 1;}
		if (!ereg("[0-9]{1,4}-[0-9]{4}", $f_tel)) {$error = 1;}
/* 入力データにエラーがない場合のみデータベースへの追加をします */
		if ($error == 0) {
/* データベースに接続します。 */
		$dbh = new PDO("sqlite:../sqlite3/kaiin.db",null,null);
/* noが登録済みの場合には、エラーにします。*/
		$sql = "SELECT count(*) FROM meibo WHERE no = ?";
/* 可変項目を配列にセットします。 */
		$temp = array($f_no);
/* 実行するSQL文を準備します。 */
		$sth = $dbh->prepare($sql);
/* SQL文を実行します。*/
		$sth->execute($temp);
/* noが登録済みか確認します。重複していたら$errorに2をセットします。*/
		$count = $sth->fetchColumn();
		if ($count != 0) {$error = 2;}
		else {
/* meiboテーブルにデータを追加します。 */
		$sql = "INSERT INTO meibo (no,name,kana,tel) VALUES(?,?,?,?)";
		$temp = array($f_no,$f_name,$f_kana,$f_tel);
/* 実行するSQL文を準備します。 */
		$sth = $dbh->prepare($sql);
/* SQL文を実行します。 */
		$sth->execute($temp);
/* 接続を閉じます。 */
		$dbh = null;
		}
}
?>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<title>名簿テーブルにレコードの追加</title>
</head>
<body>
<h3>ブラウザから名簿テーブルにレコードを追加。</h3>
<?php if ($error == 1) {echo "<p>記入漏れまたは記入ミスがありました。新規追加できませんでした。</p>";}
elseif ($error == 2) {echo "<p>会員番号が重複していますので、新規追加できません。</p>";}
else {echo "<p>レコードが追加されました。</p>";}
?>
<p><a href="index.php">戻る</a></p>
</body>
</html>